#!/usr/bin/env python3

import os
import re
import xml.etree.ElementTree as ET

baseDirectory = os.path.dirname(os.path.abspath(__file__)) + '/../../Data/Core/Languages/'

languageDirectories = os.listdir(baseDirectory)
languageDirectories.remove('English')

for l in languageDirectories:
		if not os.path.isdir(baseDirectory + l):
				languageDirectories.remove(l)

outputFiles = []
for l in languageDirectories:
		outputFile = open(os.path.dirname(os.path.abspath(__file__)) + '/VerifyLanguages.' + l + '.txt', 'w+')
		outputFiles.append(outputFile)

referenceDirectory = baseDirectory + '/English/'
referenceFiles = os.listdir(referenceDirectory)

missingEntries = []
missingValues = []

for f in referenceFiles:
		print("Reading: " + f)
		f_str = open(referenceDirectory + f, 'r').read()
		f_str = f_str.replace('\"<', '\"&lt;')
		f_str = f_str.replace('<b', '&lt;b')
		f_str = f_str.replace('<c', '&lt;c')
		f_str = f_str.replace('<i', '&lt;i')
		f_str = f_str.replace('<s', '&lt;s')
		f_str = f_str.replace('R&', 'R&amp;')
		f_str = f_str.replace(' & ', ' &amp; ')
		f_str = f_str.replace(' -- ', ' ')

		root_f = ET.fromstring(f_str)

		for idx, l in enumerate(languageDirectories):
				if not os.path.exists(baseDirectory + l + '/' + f):
						print(baseDirectory + l + '/' + f + ' does not exist!\n')
						continue
				else:
						l_str = open(baseDirectory + l + '/' + f, 'r').read()
						l_str = l_str.replace('\"<', '\"&lt;')
						l_str = l_str.replace('<b', '&lt;b')
						l_str = l_str.replace('<c', '&lt;c')
						l_str = l_str.replace('R&', 'R&amp;')
						l_str = l_str.replace('<s', '&lt;s')
						l_str = l_str.replace('<i', '&lt;i')
						l_str = l_str.replace(' & ', ' &amp; ')
						l_str = l_str.replace(' -- ', ' ')
						l_str = l_str.replace('d&', 'd&amp;')

						print('Verifying: ' + l + '/' + f)
						outputFiles[idx].write('Verifying: ' + f + '\n')
						root_l = ET.fromstring(l_str)

						missingEntries.clear()
						missingValues.clear()

						for child in root_f:
								entryName = child.attrib['name']
								entryValue = child.attrib['value']
								l_children = root_l.findall(child.tag)

								missing = False
								for c in l_children:
										if c.attrib['name'] == entryName:
												missing = False
												break
										else:
												missing = True
								if missing:
										missingEntries.append(entryName)

								missing = False
								if 'string name' in entryValue:
										snEntry = re.search(r'(<string name=\'(.+)\'/>)', entryValue)
										for c in l_children:
												snC = re.search(r'(<string name=\'(.+)\'/>)', c.attrib['value'])
												if 'string name' in c.attrib['value'] and snC.group(0) == snEntry.group(0):
														missing = False
														break
												else:
														missing = True
								if missing:
										missingValues.append(entryName)

						for e in missingEntries:
								try:
										missingValues.remove(e)
								except:
										pass										

						if missingEntries or missingValues:
								if missingEntries:
										print('\tMissing Entries')
										outputFiles[idx].write('\tMissing Entries\n')
										for e in missingEntries:
												print('\t\t' + e)
												outputFiles[idx].write('\t\t' + e + '\n')
								if missingValues:
										print('\tMissing/Wrong String Values')
										outputFiles[idx].write('\tMissing/Wrong String Values\n')
										for v in missingValues:
												print('\t\t' + v)
												outputFiles[idx].write('\t\t' + v + '\n')
